/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.XYPlot;
import java.awt.Container;
import java.awt.Graphics;
import java.util.Vector;

public class DistPlot
extends XYPlot {
    public DistPlot(Container parent) {
        super(parent);
        this.title = "Dist";
        this.xLabel = "p (sec/km or km-sec/km)";
        this.yLabel = "dist (sec)";
        this.yTickWidth = 10;
    }

    public DistPlot(Container parent, int width, int height) {
        super(parent, width, height);
        this.title = "Dist (km)";
        this.xLabel = "p (sec/km or km-sec/km)";
        this.yLabel = "distance (km)";
        this.yTickWidth = 10;
    }

    public void plot(TauModel tModel, boolean isPWave) {
        int waveNum;
        if (!isPWave) {
            waveNum = 1;
            this.zoomMinX = this.minX = 0.0;
            this.zoomMaxX = this.maxX = 2000.0;
            this.zoomMinY = this.minY = 0.0;
            this.zoomMaxY = this.maxY = 270.0;
        } else {
            waveNum = 0;
            this.zoomMinX = this.minX = 0.0;
            this.zoomMaxX = this.maxX = 1300.0;
            this.zoomMinY = this.minY = 0.0;
            this.zoomMaxY = this.maxY = 200.0;
        }
        int jj = 0;
        this.xSegments = new Vector();
        this.ySegments = new Vector();
        for (int i = 0; i < tModel.tauBranches[waveNum].length; ++i) {
            jj = 0;
            double[] tempXData = new double[tModel.rayParams.length];
            double[] tempYData = new double[tModel.rayParams.length];
            for (int j = 0; j < tModel.rayParams.length; ++j) {
                double x = tModel.rayParams[j];
                double y = 0.0;
                for (int k = 0; k <= i; ++k) {
                    y += 2.0 * tModel.tauBranches[waveNum][k].getDist(j);
                }
                if ((y *= 57.29577951308232) == 0.0 && x != 0.0 || tModel.tauBranches[waveNum][i].getDist(j) == 0.0) continue;
                tempXData[jj] = x;
                tempYData[jj] = y;
                if (this.DEBUG) {
                    System.out.println(x + " " + y);
                }
                ++jj;
            }
            if (this.DEBUG) {
                System.out.println("> ");
            }
            this.xData = new double[jj];
            System.arraycopy(tempXData, 0, this.xData, 0, jj);
            this.yData = new double[jj];
            System.arraycopy(tempYData, 0, this.yData, 0, jj);
            this.xSegments.addElement(this.xData);
            this.ySegments.addElement(this.yData);
            this.xData = null;
            this.yData = null;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }
}

