/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPlot;
import java.awt.Color;
import java.awt.Graphics;

public class PathPlot
extends ArrivalPlot {
    public PathPlot() {
        this.setOpaque(true);
    }

    @Override
    public void paintBackground(Graphics g) {
        int xOffset = this.getSize().width / 2;
        int yOffset = this.getSize().height / 2;
        int pixelRad = Math.min(xOffset, yOffset);
        double roe = 6371.0;
        Color origColor = g.getColor();
        Color aColor = new Color(220, 220, 220);
        Color bColor = Color.white;
        Color fillColor = aColor;
        boolean whichColor = true;
        if (this.tMod != null) {
            roe = this.tMod.getRadiusOfEarth();
            int disconRad = pixelRad;
            fillColor = whichColor ? aColor : bColor;
            g.setColor(fillColor);
            whichColor = !whichColor;
            g.fillOval(xOffset - disconRad, yOffset - disconRad, 2 * disconRad, 2 * disconRad);
            for (int i = 0; i < this.tMod.tauBranches[0].length - 1; ++i) {
                if (this.tMod.tauBranches[0][i].getBotDepth() != this.tMod.tauBranches[1][i].getBotDepth()) {
                    disconRad = (int)Math.round((this.tMod.getRadiusOfEarth() - this.tMod.tauBranches[0][i].getBotDepth()) / roe * (double)pixelRad);
                    fillColor = whichColor ? aColor : bColor;
                    g.setColor(fillColor);
                    whichColor = !whichColor;
                    g.fillOval(xOffset - disconRad, yOffset - disconRad, 2 * disconRad, 2 * disconRad);
                    continue;
                }
                disconRad = (int)Math.round((this.tMod.getRadiusOfEarth() - this.tMod.tauBranches[1][i].getBotDepth()) / roe * (double)pixelRad);
                fillColor = whichColor ? aColor : bColor;
                g.setColor(fillColor);
                whichColor = !whichColor;
                g.fillOval(xOffset - disconRad, yOffset - disconRad, 2 * disconRad, 2 * disconRad);
            }
        }
        g.setColor(origColor);
    }

    @Override
    public void paintArrivals(Graphics g) {
        for (int i = 0; i < this.arrivals.size(); ++i) {
            this.paintPaths(g, i);
        }
    }

    @Override
    public void paintForeground(Graphics g) {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.arrivals.size()) {
            Color orig = g.getColor();
            g.setColor(Color.red);
            this.paintPaths(g, this.selectedIndex);
            g.setColor(orig);
        }
    }

    protected void paintPaths(Graphics g, int i) {
        int xOffset = this.getSize().width / 2;
        int yOffset = this.getSize().height / 2;
        int pixelRad = Math.min(xOffset, yOffset);
        double roe = 6371.0;
        Arrival a = (Arrival)this.arrivals.elementAt(i);
        int[] x = new int[a.getNumPathPoints()];
        int[] y = new int[a.getNumPathPoints()];
        if (a.getDist() * 180.0 / Math.PI % 360.0 > 180.0) {
            for (int j = 0; j < x.length; ++j) {
                x[j] = xOffset + (int)Math.rint(Math.sin(-1.0 * a.getPathPoint(j).getDistRadian()) * (roe - a.getPathPoint(j).getDepth()) / roe * (double)pixelRad);
                y[j] = yOffset - (int)Math.rint(Math.cos(-1.0 * a.getPathPoint(j).getDistRadian()) * (roe - a.getPathPoint(j).getDepth()) / roe * (double)pixelRad);
            }
        } else {
            for (int j = 0; j < x.length; ++j) {
                x[j] = xOffset + (int)Math.rint(Math.sin(a.getPathPoint(j).getDistRadian()) * (roe - a.getPathPoint(j).getDepth()) / roe * (double)pixelRad);
                y[j] = yOffset - (int)Math.rint(Math.cos(a.getPathPoint(j).getDistRadian()) * (roe - a.getPathPoint(j).getDepth()) / roe * (double)pixelRad);
            }
        }
        g.drawPolyline(x, y, x.length);
    }
}

