/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TauModel;

public class SeismicPhaseSegment {
    TauModel tMod;
    int startBranch;
    int endBranch;
    boolean isPWave;
    int endAction;
    boolean isDownGoing;
    String legName;

    public SeismicPhaseSegment(TauModel tMod, int startBranch, int endBranch, boolean isPWave, int endAction, boolean isDownGoing, String legName) {
        this.tMod = tMod;
        this.startBranch = startBranch;
        this.endBranch = endBranch;
        this.isPWave = isPWave;
        this.endAction = endAction;
        this.isDownGoing = isDownGoing;
        this.legName = legName;
    }

    public static String endActionToString(int endAction) {
        String action;
        switch (endAction) {
            case 0: {
                action = "turn";
                break;
            }
            case 1: {
                action = "reflect underside";
                break;
            }
            case 8: {
                action = "critical reflect underside";
                break;
            }
            case 2: {
                action = "reflect topside";
                break;
            }
            case 9: {
                action = "critical reflect topside";
                break;
            }
            case 3: {
                action = "transmit up";
                break;
            }
            case 4: {
                action = "transmit down";
                break;
            }
            case 5: {
                action = "diffract";
                break;
            }
            case 6: {
                action = "end";
                break;
            }
            default: {
                action = "unknown";
            }
        }
        return action;
    }

    public String describeBranchRange(int startBranch, int endBranch) {
        String out = "";
        out = startBranch < this.tMod.getMohoBranch() && endBranch < this.tMod.getMohoBranch() ? "crust" : (startBranch < this.tMod.getCmbBranch() && endBranch < this.tMod.getCmbBranch() ? (startBranch < this.tMod.getMohoBranch() && endBranch > this.tMod.getMohoBranch() ? "crust/mantle" : (startBranch > this.tMod.getMohoBranch() && endBranch < this.tMod.getMohoBranch() ? "crust/mantle" : "mantle")) : (startBranch <= this.tMod.getIocbBranch() && endBranch <= this.tMod.getIocbBranch() ? "outer core" : "inner core"));
        return out;
    }

    public String toString() {
        String isPString;
        String desc = "";
        String upDown = this.isDownGoing ? "down" : "up  ";
        String action = SeismicPhaseSegment.endActionToString(this.endAction);
        String string = isPString = this.isPWave ? "P" : "S";
        if (!(this.isPWave || this.startBranch != this.tMod.getCmbBranch() && this.endBranch != this.tMod.getCmbBranch())) {
            isPString = "P";
        }
        String branchRange = this.startBranch == this.endBranch ? " layer " + this.startBranch : " layer " + this.startBranch + " to " + this.endBranch;
        String depthRange = this.isDownGoing ? this.tMod.getTauBranch(this.startBranch, this.isPWave).getTopDepth() + " to " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() : this.tMod.getTauBranch(this.startBranch, this.isPWave).getBotDepth() + " to " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth();
        desc = !this.legName.contentEquals("END") ? desc + this.legName + " going " + upDown + " as a " + isPString + " in the " + this.describeBranchRange(this.startBranch, this.endBranch) + "," + branchRange + ", depths " + depthRange + ", then " + action : desc + "END";
        return desc;
    }
}

