/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Path;
import edu.sc.seis.TauP.Theta;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.ToolRun;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TauP_Wavefront
extends TauP_Path {
    int numRays = 30;
    float timeStep = 100.0f;
    boolean separateFilesByTime = false;
    boolean negDistance = false;
    boolean doInteractive = true;
    Map<SeismicPhase, Map<Float, List<TimeDist>>> result;

    public TauP_Wavefront() {
        this.setOutFileBase("taup_wavefront");
    }

    public TauP_Wavefront(String modelName, String outFileBase) throws TauModelException {
        super(modelName, outFileBase);
    }

    public TauP_Wavefront(String modelName) throws TauModelException {
        super(modelName);
        this.setOutFileBase("taup_wavefront");
    }

    public TauP_Wavefront(TauModel tMod, String outFileBase) throws TauModelException {
        super(tMod, outFileBase);
    }

    public TauP_Wavefront(TauModel tMod) throws TauModelException {
        super(tMod);
        this.setOutFileBase("taup_wavefront");
    }

    @Override
    public void calculate(double degrees) throws TauModelException {
        this.result = this.calcIsochron();
    }

    @Override
    public void printUsage() {
        this.printStdUsage();
        System.out.println("--gmt             -- outputs path as a complete GMT script.");
        System.out.println("--mapwidth        -- sets map width for GMT script.");
        System.out.println("--rays  num      -- number of raypaths/distances to sample.");
        System.out.println("--timestep  num  -- steps in time (seconds) for output.");
        System.out.println("--timefiles      -- outputs each time into a separate .ps file within the gmt script.");
        System.out.println("--negdist        -- outputs negative distance as well so wavefronts are in both halves.");
        TauP_Wavefront.printStdUsageTail();
    }

    @Override
    public void printScriptBeginning(PrintWriter out) throws IOException {
        if (!this.gmtScript) {
            return;
        }
        if (this.getOutFile().equals("stdout")) {
            this.psFile = "taup_wavefront.ps";
        }
        super.printScriptBeginning(out);
    }

    @Override
    public void printResult(PrintWriter out) throws IOException {
        String byTimePsFile = this.psFile;
        double radiusOfEarth = this.getTauModelDepthCorrected().getRadiusOfEarth();
        HashSet<Float> keySet = new HashSet<Float>();
        for (SeismicPhase phase : this.result.keySet()) {
            Map<Float, List<TimeDist>> phaseResult = this.result.get(phase);
            keySet.addAll(phaseResult.keySet());
        }
        if (keySet.size() == 0) {
            System.err.println("taup wavefront, no phases successful...");
            return;
        }
        ArrayList<Float> keys = new ArrayList<Float>();
        keys.addAll(keySet);
        Collections.sort(keys);
        Float lastTime = (Float)keys.get(keys.size() - 1);
        int numDigits = 1;
        String formatStr = "0";
        while (Math.pow(10.0, numDigits) < (double)lastTime.floatValue()) {
            ++numDigits;
            formatStr = formatStr + "0";
        }
        if (lastTime.floatValue() < 1.0f) {
            formatStr = formatStr + ".0";
            int fracDigits = 0;
            while (Math.pow(10.0, fracDigits) > (double)lastTime.floatValue()) {
                --fracDigits;
                formatStr = formatStr + "0";
            }
        }
        DecimalFormat format = new DecimalFormat(formatStr, new DecimalFormatSymbols(Locale.US));
        PrintWriter timeOut = out;
        for (Float time : keys) {
            if (this.separateFilesByTime) {
                String psFileBase = this.psFile;
                if (this.gmtScript && this.psFile.endsWith(".ps")) {
                    psFileBase = this.psFile.substring(0, this.psFile.length() - 3);
                }
                String timeExt = "_" + format.format(time);
                byTimePsFile = psFileBase + timeExt + ".ps";
                String timeOutName = this.getOutFileBase() + timeExt;
                if (this.getOutFile().endsWith(".gmt")) {
                    timeOutName = this.getOutFile().substring(0, this.getOutFile().length() - 4) + timeExt + ".gmt";
                }
                if (timeOut != null && timeOut != out) {
                    timeOut.close();
                }
                timeOut = new PrintWriter(new BufferedWriter(new FileWriter(timeOutName)));
                if (this.gmtScript) {
                    this.printScriptBeginning(timeOut, byTimePsFile);
                }
            }
            if (this.gmtScript) {
                timeOut.println("# timestep = " + time);
                timeOut.println("gmt psxy -P -R -K -O -Wblue -JP -m -A >> " + byTimePsFile + " <<END");
            }
            for (SeismicPhase phase : this.result.keySet()) {
                Map<Float, List<TimeDist>> phaseResult = this.result.get(phase);
                List<TimeDist> wavefront = phaseResult.get(time);
                if (wavefront == null || wavefront.size() == 0) continue;
                timeOut.println("> " + phase.getName() + " at " + time + " seconds");
                Collections.sort(wavefront, new Comparator<TimeDist>(){

                    @Override
                    public int compare(TimeDist arg0, TimeDist arg1) {
                        return Double.valueOf(arg0.getP()).compareTo(arg1.getP());
                    }
                });
                for (TimeDist td : wavefront) {
                    timeOut.println(Outputs.formatDistance(td.getDistDeg()) + "  " + Outputs.formatDepth(radiusOfEarth - td.getDepth()) + " " + Outputs.formatTime(time.floatValue()) + " " + Outputs.formatRayParam(td.getP()));
                }
                if (!this.isNegDistance()) continue;
                timeOut.write("> " + phase.getName() + " at " + time + " seconds (neg distance)\n");
                for (TimeDist td : wavefront) {
                    timeOut.println(Outputs.formatDistance(-1.0 * td.getDistDeg()) + "  " + Outputs.formatDepth(radiusOfEarth - td.getDepth()) + " " + Outputs.formatTime(time.floatValue()) + " " + Outputs.formatRayParam(td.getP()));
                }
            }
            if (!this.gmtScript) continue;
            timeOut.println("END");
            if (!this.separateFilesByTime) continue;
            timeOut.println("# end postscript");
            timeOut.println("gmt psxy -P -R -O -JP -m -A -T >> " + byTimePsFile);
            timeOut.println("# convert ps to pdf, clean up .ps file");
            timeOut.println("gmt psconvert -P -Tf  " + byTimePsFile + " && rm " + byTimePsFile);
            timeOut.println("# clean up after gmt...");
            timeOut.println("/bin/rm gmt.history");
        }
        if (this.gmtScript && !this.separateFilesByTime) {
            out.println("# end postscript");
            out.println("gmt psxy -P -R -O -JP -m -A -T >> " + byTimePsFile);
            out.println("# convert ps to pdf, clean up .ps file");
            out.println("gmt psconvert -P -Tf  " + byTimePsFile + " && rm " + byTimePsFile);
            out.println("# clean up after gmt...");
            out.println("rm gmt.history");
        }
        timeOut.flush();
        out.flush();
    }

    public Map<SeismicPhase, Map<Float, List<TimeDist>>> calcIsochron() throws TauModelException {
        this.depthCorrect(this.getSourceDepth(), this.getReceiverDepth());
        HashMap<SeismicPhase, Map<Float, List<TimeDist>>> resultOut = new HashMap<SeismicPhase, Map<Float, List<TimeDist>>>();
        this.clearArrivals();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            SeismicPhase phase = phaseList.get(phaseNum);
            if (this.verbose) {
                System.out.println("Work on " + phase.getName());
            }
            double minDist = phase.getMinDistanceDeg();
            double maxDist = phase.getMaxDistanceDeg();
            double deltaDist = (maxDist - minDist) / (double)(this.numRays - 1);
            this.degrees = minDist;
            ArrayList<Arrival> allArrival = new ArrayList<Arrival>();
            for (int r = 0; r < this.getNumRays(); ++r) {
                this.degrees = minDist + (double)r * deltaDist;
                List<Arrival> phaseArrivals = phase.calcTime(this.degrees);
                allArrival.addAll(phaseArrivals);
            }
            HashMap<Float, ArrayList<TimeDist>> out = new HashMap<Float, ArrayList<TimeDist>>();
            resultOut.put(phase, out);
            boolean done = false;
            float timeVal = 0.0f;
            while (!done) {
                done = true;
                timeVal += this.timeStep;
                if (this.verbose) {
                    System.out.println("Time " + timeVal + " for " + phase.getName() + " " + allArrival.size());
                }
                block3: for (Arrival arrival : allArrival) {
                    TimeDist[] path = arrival.getPath();
                    for (int i = 0; i < path.length; ++i) {
                        if (!(path[i].getTime() <= (double)timeVal) || i >= path.length - 1 || !((double)timeVal < path[i + 1].getTime())) continue;
                        TimeDist interp = this.interp(path[i], path[i + 1], timeVal);
                        ArrayList<TimeDist> tdList = (ArrayList<TimeDist>)out.get(Float.valueOf(timeVal));
                        if (tdList == null) {
                            tdList = new ArrayList<TimeDist>();
                            out.put(Float.valueOf(timeVal), tdList);
                        }
                        tdList.add(interp);
                        done = false;
                        continue block3;
                    }
                }
            }
        }
        return resultOut;
    }

    TimeDist interp(TimeDist x, TimeDist y, float t) {
        return new TimeDist(x.getP(), t, Theta.linInterp(x.getTime(), y.getTime(), x.getDistRadian(), y.getDistRadian(), t), Theta.linInterp(x.getTime(), y.getTime(), x.getDepth(), y.getDepth(), t));
    }

    public void setNumRays(int numRays) {
        this.numRays = numRays;
    }

    public int getNumRays() {
        return this.numRays;
    }

    public float getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(float timeStep) {
        this.timeStep = timeStep;
    }

    public boolean isSeparateFilesByTime() {
        return this.separateFilesByTime;
    }

    public void setSeparateFilesByTime(boolean separateFilesByTime) {
        this.separateFilesByTime = separateFilesByTime;
    }

    public boolean isNegDistance() {
        return this.negDistance;
    }

    public void setNegDistance(boolean negDistance) {
        this.negDistance = negDistance;
    }

    @Override
    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int i = 0;
        int numNoComprendoArgs = 0;
        for (int j = 0; j < args.length; ++j) {
            if (!TauP_Wavefront.dashEquals("h", args[j])) continue;
            this.doInteractive = false;
        }
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        while (i < leftOverArgs.length) {
            if (TauP_Wavefront.dashEquals("gmt", leftOverArgs[i])) {
                this.gmtScript = true;
            } else if (TauP_Wavefront.dashEquals("timefiles", leftOverArgs[i])) {
                this.separateFilesByTime = true;
            } else if (TauP_Wavefront.dashEquals("negdist", leftOverArgs[i])) {
                this.negDistance = true;
            } else if (TauP_Wavefront.dashEquals("rays", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setNumRays(Integer.parseInt(leftOverArgs[i + 1]));
                ++i;
            } else if (TauP_Wavefront.dashEquals("timestep", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setTimeStep(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
            } else if (TauP_Wavefront.dashEquals("mapwidth", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setMapWidth(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
            } else {
                noComprendoArgs[numNoComprendoArgs++] = TauP_Wavefront.dashEquals("help", leftOverArgs[i]) ? leftOverArgs[i] : leftOverArgs[i];
            }
            ++i;
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void init() throws TauPException {
        super.init();
    }

    @Override
    public void start() throws IOException, TauModelException, TauPException {
        if (this.doInteractive) {
            super.start();
        } else {
            this.calculate(this.degrees);
            this.printResult(this.getWriter());
        }
    }

    public static void main(String[] args) throws IOException {
        ToolRun.legacyRunTool(ToolRun.WAVEFRONT, args);
    }
}

