function [X_out,misfit,t0,t_isrevise,Xall,Xall0,misfite,it,ega]=pl_vt(G,ob,X0tol,iter,evalchar)
%==========================================================================
% using projected Landweber method with variable relaxations to accelerate
% converging
% solving G*X=ob
% X0tol: stopping tolerance of misfit, if X0t0l>=1, it would not be used
% iter: iteration number
% evalchar: projection of X in each iteration, such as positivity: 'X(X<0)=0;'
% X_out: solution with the minimum residual
% misfit: normalized misfit
% t0: relaxation factors, it is determined by minimizing abs{[(1-eg*t(k))]}
% Note: if the residual increases in an iteration, then use the relaxation
% 2/(max(eg)+min(eg)) to replace it, where eg is a vector consisting of all eigenvalues of (G'*G)
%              Zhang Yong, Peking University, 2022-10-27
% Reference:(these codes were developed to solve the finite-fault earthquake rupture process)
% Zhang, Y., Feng, W., Chen, Y., Xu, L., Li, Z., & Forrest, D. (2012). The 2009 L'Aquila MW 6.3 earthquake: A new technique to locate the hypocentre 
% in the joint inversion of earthquake rupture process. Geophysical Journal International, 191(3), 1417-1426.
%==========================================================================

sg=size(G);
if sg(1)>sg(2)
    GG=G'*G;
else
    GG=G*G';
end
%egmax=eigs(GG,1,'largestabs');
egmax=max(eig(GG));
% ensure egmax is no less than its ture value
egmax=egmax*(1+eps*100);

% prepare of relaxations for iterations
t0=load('t0_1e6_30.mat');
t0=t0.t0/egmax;
tmax=2/egmax;
repnum=ceil(iter/numel(t0));
t0=repmat(t0,[repnum,1]);

%tic;GG=G'*G+sparG'*sparG;eg=eig(GG);eg(eg<=0)=[];egmax=max(eg);t0c
Gob=G'*ob;
GobE=Gob'*Gob;

% prepare for iterative calculations
sg=size(G);
Xall=zeros(sg(2),iter);% solutions in all iterations
Xall0=Xall;
if numel(X0tol)>1
    X=X0tol;
else
    %X=zeros(sg(2),1)+[1;2]; % initial solution
    X=zeros(sg(2),1); % initial solution
end
misfit=zeros(iter,1); % relative misfit
misfite=zeros(iter,1); % relative misfit
obE=ob'*ob; % energy of data
numstop=0;
it=zeros(iter,1);
% calculate the residual and gradient
ex=ob-G*X;% sg(1)*sg(2)
Xe=G'*ex;% sg(1)*sg(2)
t_isrevise=zeros(iter,1);
for i=1:iter
    X0=X;    
    X=X+Xe*t0(i);    
    Xall0(:,i)=X;
    eval(evalchar);% Projection, e.g., positivity
    %X(X<0)=0;
    % calculate the residual and gradient
    %ex=ob-G*X;% sg(1)*sg(2)
    syn=G*X;fac=bestfac(ob,syn);syn=syn*fac;X=X*fac;ex=ob-syn;
    
    misfit(i)=ex'*ex/obE;
    % if t0(i) exceeds tmax, misfit(i) needs t0 be smaller than misfit(i-1)
%     if t0(i)>tmax
%         if i>1&&misfit(i)-misfit(i-1)>eps
%             t0(i)=t0def;
%             X=X0+Xe*t0(i);
%             eval(evalchar);
%             ex=ob-[G*X;sparG*X];% sg(1)*sg(2)
%             misfit(i)=ex'*ex/obE;
%             t_isrevise(i)=1;
%         end
%     end
    % if t0(i) exceeds tmax, misfit(i) needs t0 be smaller than misfit(i-1)
    if t0(i)>tmax
        if i>1&&misfit(i)-misfit(i-1)>eps
            t0i=logspace(log10(tmax/2),log10(t0(i)),40);
            X=X0+Xe*t0i;
            eval(evalchar);
            %X(X<0)=0;
            
            %ex=ob-G*X;% sg(1)*sg(2)
            syn=G*X;fac=bestfac(ob,syn);syn=syn*diag(fac);X=X*diag(fac);ex=ob-syn;
            misfitj=diag(ex'*ex)/obE;
            
            [~,nj]=min(misfitj);%figure(1e3);plot(misfitj);hold on;plot(1:40,misfit(i-1)*ones(40,1),'r');pause(1);hold off
                      
%             if nj==1
%                 t0i=logspace(log10(t0i(nj)),log10(t0i(nj+1)),40);
%             elseif nj==numel(t0i)
%                 t0i=logspace(log10(t0i(nj-1)),log10(t0i(nj)),40);
%             else
%                 t0i=logspace(log10(t0i(nj-1)),log10(t0i(nj+1)),40);
%             end
%             X=X0+Xe*t0i;
%             eval(evalchar);
%             ex=ob-[G*X;sparG*X];% sg(1)*sg(2)
%             misfitj=diag(ex'*ex)/obE;
%             [~,nj]=min(misfitj);
            
            t0(i)=t0i(nj);misfit(i)=misfitj(nj);X=X(:,nj);ex=ex(:,nj);Xall0(:,i)=X0+Xe*t0(nj);
            t_isrevise(i)=t_isrevise(i)+1;
        end
    end
    Xe=G'*ex;% sg(1)*sg(2)  
    
    misfite(i)=Xe'*Xe/GobE;%(X-X0)'*(X-X0);
     
    Xall(:,i)=X;
    
    % stop the iteration if the deepest misfit reduction (t0>tmax) has been stably small
    if i>1&&numel(X0tol)==1&&X0tol<1
        if (misfit(i-1)-misfit(i)<X0tol)&&(t0(i)>tmax)
            numstop=numstop+1;
        end
        if numstop>20
            misfit(i+1:end)=NaN;
            Xall(:,i+1:end)=[];
            t_isrevise(i+1:end)=[];
            break;
        end
    end
end

% % calculate all EG1 for revised relaxations
ega=[];

% get the solution with the minimum misfit
[~,n]=min(misfit);
X_out=Xall(:,n);