function [X_out,misfit,t0,t_isrevise,Xall,misfite,dex0]=pl_vt_spar(G,sparG,ob,X0tol,iter,evalchar,t0file)
%==========================================================================
% using projected Landweber method with variable relaxations to accelerate
% converging
% solving [G;sparG]*X=ob, where G is a dense matrix and sparG is a sparse matrix
% X0tol: stopping tolerance of misfit, if X0t0l>=1, it would not be used
% iter: iteration number
% evalchar: projection of X in each iteration, such as positivity: 'X(X<0)=0;'
% X_out: solution with the minimum residual
% misfit: normalized misfit
% t0: relaxation factors, it is determined by minimizing abs{[(1-eg*t0(k))]}
% Note: if the residual increases in an iteration, then use the relaxation
% 2/(max(eg)+min(eg)) to replace it, where eg is a vector consisting of all eigenvalues of (G'*G)
%              Zhang Yong, Peking University, 2022-10-27
% Reference:(these codes were developed to solve the finite-fault earthquake rupture process)
% Zhang, Y., Feng, W., Chen, Y., Xu, L., Li, Z., & Forrest, D. (2012). The 2009 L'Aquila MW 6.3 earthquake: A new technique to locate the hypocentre 
% in the joint inversion of earthquake rupture process. Geophysical Journal International, 191(3), 1417-1426.
%==========================================================================

sg=size(G);
%% get the maximum eigenvalue of G'*G
% accurate but slow estimate
% GG=G'*G+sparG'*sparG;%Gt=G';
% egmax=eigs(GG,1,'largestabs'); 
% egmax=egmax*(1+eps*1e2);

% fast but roughly estimate
if sg(1)>=sg(2)
    GG1=G'*G;
    GG2=sparG'*sparG;
    GG=GG1+GG2;
    od=1;
else
    GG1=G*G';
    GG2=sparG'*sparG;
    od=0;
end
egmax1=eigs(GG1,1,'largestabs');
egmax2=eigs(GG2,1,'largestabs');
egmax=max(egmax1,egmax2);
egmax=egmax*1.001;%egmax=6e4;

% prepare of relaxations for iterations
if nargin<7
    t0=load('t0_1e6_30.mat');
else
    t0=load(t0file);
end
t0=t0.t0;t0(t0==0)=[];
t0=t0/egmax;%t0(1:1e5)=[];

tmax=2/egmax;
repnum=ceil(iter/numel(t0));
t0=repmat(t0,[repnum,1]);

Gob=G'*ob(1:sg(1))+sparG'*ob(1+sg(1):end);
GobE=Gob'*Gob;

misfit=zeros(iter,1); % relative misfit
misfite=zeros(iter,1); % relative misfit
obE=ob'*ob; % energy of data
numstop=0;

% prepare for iterative calculations
sg=size(G);
Xall=zeros(sg(2),iter);% solutions in all iterations
% calculate the residual and gradient
if numel(X0tol)>1
    X=X0tol;
else
    X=zeros(sg(2),1); % initial solution
end
ex=ob-[G*X;sparG*X];% sg(1)*sg(2)
Xe=G'*ex(1:sg(1))+sparG'*ex(sg(1)+1:end);% sg(1)*sg(2)
t_isrevise=zeros(iter,1);

dex0=Xall;
for i=1:iter
    X0=X;    
    X=X+Xe*t0(i);    
    eval(evalchar);% Projection, e.g., positivity
    
    dex0(:,i)=Xe*t0(i);
    
    % calculate the residual and gradient
    %ex=ob-[G*X;sparG*X];% sg(1)*sg(2)
    syn=[G*X;sparG*X];fac=bestfac(ob,syn);syn=syn*fac;X=X*fac;ex=ob-syn;
    
    misfit(i)=ex'*ex/obE;

    % if t0(i) exceeds tmax, misfit(i) needs t0 be smaller than misfit(i-1)
    if t0(i)>tmax
        if (i==1&&misfit(i)>1)||(i>1&&misfit(i)-misfit(i-1)>eps)
            t0i=logspace(log10(tmax/2),log10(t0(i)),40);
            X=X0+Xe*t0i;
            eval(evalchar);
            %ex=ob-[G*X;sparG*X];% sg(1)*sg(2)
            syn=[G*X;sparG*X];fac=bestfac(ob,syn);syn=syn*diag(fac);X=X*diag(fac);ex=ob-syn;
            misfitj=diag(ex'*ex)/obE;
            
            [~,nj]=min(misfitj);%figure(1e3);plot(misfitj);hold on;plot(1:40,misfit(i-1)*ones(40,1),'r');pause(1);hold off
            
            for kk=1:0
                if nj==1
                    t0i=logspace(log10(t0i(nj)/2),log10(t0i(nj+1)),20);
                elseif nj==numel(t0i)
                    t0i=logspace(log10(t0i(nj-1)),log10(t0i(nj)*2),20);
                else
                    t0i=logspace(log10(t0i(nj-1)),log10(t0i(nj+1)),20);
                end
                X=X0+Xe*t0i;
                eval(evalchar);
                %ex=ob-[G*X;sparG*X];% sg(1)*sg(2)
                syn=[G*X;sparG*X];fac=bestfac(ob,syn);syn=syn*diag(fac);X=X*diag(fac);ex=ob-syn;
                
                misfitj=diag(ex'*ex)/obE;
                [~,nj]=min(misfitj);
            end
            
            t0(i)=t0i(nj);misfit(i)=misfitj(nj);X=X(:,nj);ex=ex(:,nj);
            t_isrevise(i)=t_isrevise(i)+1;
            
            dex0(:,i)=Xe*t0(i);
        end
    end
        
    Xe=G'*ex(1:sg(1))+sparG'*ex(sg(1)+1:end);% sg(1)*sg(2)  
  
    misfite(i)=Xe'*Xe/GobE;%(X-X0)'*(X-X0);
     
    Xall(:,i)=X;
    
    % st0p the iteration if the deepest misfit reduction (t0>tmax) has been stably small
    if i>1&&numel(X0tol)==1&&X0tol<1
        if (misfit(i-1)-misfit(i)<X0tol)&&(t0(i)>tmax)
            numstop=numstop+1;
        end
        if numstop>20
            misfit(i+1:end)=NaN;
            Xall(:,i+1:end)=[];
            t_isrevise(i+1:end)=[];
            break;
        end
    end
end

% get the solution with the minimum misfit
[~,n]=min(misfit);
X_out=Xall(:,n);