clearvars
close all

M=8e3;N=4e3;
g=randn(M,1); % green's function
stf=sin(linspace(0,pi,N)');stf(stf<0)=0; % source time function
ob=conv(g,stf); % observation equals the convolution of g and stf

ob=ob+max(abs(ob)).*randn(size(ob)).*0.1;% add noise

len=numel(stf)*1.5;
G=convmtx(g,len); % convolution matrix
G(numel(g)+1:end,:)=[];ob(numel(g)+1:end)=[]; % ensure the number of rows in G equal the length of g

%% pl_vt: developed by Yong Zhang based on the Landweber method with varied relaxation factors
tic;[stf1,rsq1]=pl_vt(G,ob,1e-99,1000,'X(X<0)=0;');t1=toc;

%% below codes are based on the method proposed by Lawson, C. L., & Hanson, R. J. (1995). Solving least squares problems. Society for Industrial and Applied Mathematics.
% matlab function 'lsqnonneg', but revised to output all residuals in each iteration
tic;[stf2,rsq2] = lsqnonneg_re(G,ob);t2=toc;
% same as 'lsqnonneg', but programmed by W.Whiten in 2012
tic;[stf3,stfall]=nnls(G,ob);t3=toc;
res=G*stfall-ob;rsq3=sum(res.^2)'./sum(ob.^2);

%% the method of Lin, C. J. (2007). Projected gradient methods for nonnegative matrix factorization. Neural computation, 19(10), 2756-2779.
tic;[stf4,grad,iter,stfall] = nlssubprob(ob,G,zeros(len,1),1e-99,3000);t4=toc;
res=G*stfall-ob;rsq4=sum(res.^2)'./sum(ob.^2);

%% plot the residuals
minrsq=min([rsq1;rsq2;rsq3;rsq4])-eps;
figure;
semilogy(rsq1-minrsq,'r','linewidth',4);
hold on;
plot(rsq4-minrsq,'g','linewidth',4)
plot(rsq2-minrsq,'c','linewidth',4);
plot(rsq3-minrsq,'k','linewidth',1)

legend({['PL__VT: ',num2str(round(t1)),' s'],['NLSSUBPROB: ',num2str(round(t4)),' s'],...
    ['LSQNONNEG: ',num2str(round(t2)),' s'],['NNLS: ',num2str(round(t3)),' s']},'fontsize',15)
set(gca,'fontsize',14);
set(gca,'xscale','line','xlim',[0,4500]);
xlabel('Iteration');
ylabel('Normalized residuals minus the minimum value')

% stf(numel(stf1))=0;
% disp(corr([stf,stf1,stf2,stf3,stf4]))